#!/usr/bin/python

# Argumets:
# 1) phase (p0)
# 2) sampling schedule file (Sampling.txt)
# 3) Algorithm (IST/IRLS)
# 4) Number of iterations
# 5) Virtual echo (y/n)

# ./1D_varian_chunks.py 182 Sampling.txt IST 300 y

from numpy import *
import nmrglue as ng
import sys
import os
import struct

print "\nReading data...",
dic, data = ng.fileio.varian.read(fid_file='fid', procpar_file='procpar')
D = len(data)
print "done!\n"

### Phasing
print "\nPhasing...",
phase = float(sys.argv[1])
data = data*exp(-1j*phase*pi/180)
print "done!\n"

### Schedule for MDD
print "\nReading sampling scheme...",
try:
    sched = loadtxt(sys.argv[2], delimiter='-')
except ValueError:
    print "\nWrong schedule format! Script terminated."
    sys.exit()
start = sched[:, 0]
end = sched[:, 1]
print "done!\n"

ind = ()
for i in range(len(sched)):
    ind = hstack((ind, arange(start[i], end[i] + 1)))
I = len(ind)
ind = ind.astype(int) 
k = 0
ind_alternated = zeros(2*I)
for i in range(I):
    ind_alternated[k] = 2*ind[i]
    ind_alternated[k + 1] = ind_alternated[k] + 1
    k = k + 2
ind_alternated = ind_alternated.astype(int)

### FID for MDD
fid = data[ind]
fid_alternated = empty(2*I)
fid_alternated[0::2] = real(fid)
fid_alternated[1::2] = imag(fid)

### Writing to file .MDD
print "\nPreparing .mdd file...",
regions = 1
dimensions = 2

line1 = str(dimensions) + ' 1 ' + str(regions*2*I) + '\n'
line2 = str(regions) + ' ' + str(2*D)
s = ''
for i in range(2*I):
    s = s + '\n' + str(0) + ' ' + str(ind_alternated[i])
f = ''
for i in range(2*I):
    f = f + '\n' + str(fid_alternated[i])
contents = 'mdd asc sparse f180.0 \n ./MDD/region01.mdd \n MDD sparse\n $ \n' + line1 + line2 + s + f # contains the data to be written to .mdd file

folder = os.getcwd() + '/MDD/' 
if not os.path.exists(folder):
    os.makedirs(folder)
os.chdir(folder)
file = open('region01.mdd', 'w')
file.write(contents)
file.close()
print "done!\n"

print "\nReconstructing gaps..."
os.system("tcsh -c  'cssolver region01 CS_alg=" +sys.argv[3]+ " CS_niter="+sys.argv[4]+" CS_VE="+sys.argv[5]+" CS_ZF=2 MDD_NOISE=1 > region01.log'") # executes .mdd file
print "done!\n"

### Reading .CS file
print "\nMaking fid_rec file...",
file = open('region01.cs', 'rb')
cs = empty(2*D)
for i in range(2*D):
    cs[i] = float(struct.unpack('f', file.read(4))[0])
file.close()
fid_rec = cs[0::2] + 1j*cs[1::2] # to be written to "fid" file

### Wrinting to .FID file
os.chdir("..")
ng.fileio.varian.write(os.getcwd(), dic, fid_rec, fid_file='fid_rec', procpar_file='procpar_rec', overwrite=True)
print "done!\n"
